<?php
function installDatabase() {
    $host = 'localhost';
    $user = 'seu user aqui';
    $pass = 'sua senha aqui';
    $dbname = 'seu dbaqui';
    
    try {
        // Conecta sem selecionar banco
        $pdo = new PDO("mysql:host=$host", $user, $pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Cria banco se não existir
        $pdo->exec("CREATE DATABASE IF NOT EXISTS $dbname");
        $pdo->exec("USE $dbname");
        
        // Tabela de usuários
        $pdo->exec("CREATE TABLE IF NOT EXISTS usuarios (
            id INT AUTO_INCREMENT PRIMARY KEY,
            nome VARCHAR(100) NOT NULL,
            email VARCHAR(100) NOT NULL UNIQUE,
            login VARCHAR(50) NOT NULL UNIQUE,
            senha VARCHAR(255) NOT NULL,
            tipo ENUM('admin','usuario') DEFAULT 'usuario',
            data_criacao TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            ultimo_login DATETIME NULL,
            ativo BOOLEAN DEFAULT TRUE
        )");
        
        // Tabela de planos (agora vinculada ao usuário)
        $pdo->exec("CREATE TABLE IF NOT EXISTS planos (
            id INT AUTO_INCREMENT PRIMARY KEY,
            usuario_id INT NOT NULL,
            nome VARCHAR(100) NOT NULL,
            tipo VARCHAR(50) NOT NULL,
            dias INT NOT NULL,
            valor DECIMAL(10,2) NOT NULL,
            creditos TEXT,
            data_criacao TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE CASCADE
        )");
        
        // Tabela de servidores (agora vinculada ao usuário)
        $pdo->exec("CREATE TABLE IF NOT EXISTS servidores (
            id INT AUTO_INCREMENT PRIMARY KEY,
            usuario_id INT NOT NULL,
            nome VARCHAR(100) NOT NULL,
            tipo VARCHAR(50) NOT NULL,
            url VARCHAR(255) NOT NULL,
            status ENUM('ativo','inativo') DEFAULT 'ativo',
            data_criacao TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE CASCADE
        )");
        
        // Tabela de clientes (agora vinculada ao usuário)
        $pdo->exec("CREATE TABLE IF NOT EXISTS clientes (
            id INT AUTO_INCREMENT PRIMARY KEY,
            usuario_id INT NOT NULL,
            nome VARCHAR(100) NOT NULL,
            telefone VARCHAR(20) NOT NULL,
            plano_id INT NOT NULL,
            servidor_id INT,
            data_vencimento DATE NOT NULL,
            observacoes TEXT,
            status ENUM('ativo','inativo','pendente') DEFAULT 'ativo',
            data_criacao TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE CASCADE,
            FOREIGN KEY (plano_id) REFERENCES planos(id),
            FOREIGN KEY (servidor_id) REFERENCES servidores(id)
        )");
        
        // Tabela de logs de segurança
        $pdo->exec("CREATE TABLE IF NOT EXISTS security_logs (
            id INT AUTO_INCREMENT PRIMARY KEY,
            usuario_id INT NULL,
            acao VARCHAR(100) NOT NULL,
            ip_address VARCHAR(45) NOT NULL,
            user_agent TEXT,
            data_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE SET NULL
        )");
        
        // Insere admin se não existir
        $stmt = $pdo->query("SELECT COUNT(*) FROM usuarios WHERE login = 'admin'");
        if ($stmt->fetchColumn() == 0) {
            $senha_hash = password_hash('Admin@123456', PASSWORD_DEFAULT);
            $pdo->prepare("INSERT INTO usuarios (nome, email, login, senha, tipo) VALUES (?,?,?,?,?)")
                ->execute(['Administrador Gestor', 'admin@admin.com', 'admin', $senha_hash, 'admin']);
        }
        
        return $pdo;
        
    } catch (PDOException $e) {
        die("
        <!DOCTYPE html>
        <html>
        <head>
            <title>Erro de Instalação - Gestor/title>
            <style>
                body { font-family: Arial, sans-serif; max-width: 600px; margin: 100px auto; padding: 20px; }
                .error { background: #fee; border: 2px solid #f00; padding: 20px; border-radius: 10px; }
            </style>
        </head>
        <body>
            <div class='error'>
                <h2>❌ Erro de Instalação do Banco - Gestor</h2>
                <p><strong>Erro:</strong> {$e->getMessage()}</p>
                <p>Verifique se o MySQL está rodando e as credenciais no arquivo database.php</p>
            </div>
        </body>
        </html>");
    }
}

$pdo = installDatabase();
?>